// What this script is:
// This specially named script will be executed
// when the user clicks the Build button or 
// selects the Project > Build Application menu.
//
// It overrides building so that regardless of
// which targets are selected in the navigator
// we only build to match the current system.

// Select the correct 64-Bit target value for the current platform
Dim target As Integer = 0
#If TargetMacOS
#If TargetARM
target = 24
#Else
target = 16
#EndIf
#ElseIf TargetWindows
target = 19 
#ElseIf TargetLinux
target = 17
#EndIf

// If the target was set, build ONLY for that target
If Target > 0 Then
Call BuildApp(target, True)
Else
print "Could not figure out what to build!"
End If


