package com.example.utility

import android.content.Context
import android.os.VibrationEffect
import android.os.Vibrator
import androidx.core.content.ContextCompat.getSystemService

class device {
    companion object {

        /*
        The app context is required to call getSystemService, so it is passed in from the
        Xojo app using MobileApplication.AndroidContextHandle.

        That is treated as an Any? type once it gets translated from a Xojo Ptr, so it function
        declaration here needs to also declare the parameter as Any?.

        Kotlin note: The trailing "?" indicates to Kotlin that the parameter can contain a null
        value. This is required because an object parameter in Xojo is nullable.
         */
        fun vibrate(context: Any?, milliseconds: Long) {
            // Check for invalid parameters.
            if (context == null) return
            if (context !is Context) return

            // Get instance of Vibrator from the app Context
            // https://developer.android.com/reference/android/os/Vibrator#vibrate(android.os.VibrationEffect)

            val v = context.getSystemService(Context.VIBRATOR_SERVICE) as Vibrator?

            // Vibrate for the specified number of milliseconds
            val ve = VibrationEffect.createOneShot(milliseconds, 50)
            v!!.vibrate(ve)
        }
    }
}