; Sample script for creating an installer for a desktop application
; To use this script, replace "XojoApp" with the name of your application.

[Setup]
; NOTE: The value of AppId uniquely identifies this application.
; Do not use the same AppId value in installers for other applications.
; (To generate a new GUID, click Tools | Generate GUID inside the IDE.) 
AppId={{B104D606-3C81-45CF-A209-82C315FF3752}
AppName=FileTypeSetExample
AppVerName=FileTypeSetExample 1.0
AppPublisher=FileTypeSetExample Company
AppPublisherURL=
AppSupportURL=
AppUpdatesURL=
DefaultDirName={pf}\FileTypeSetExample
DefaultGroupName=FileTypeSetExample
OutputDir=C:\Users\Paul Lefebvre\Documents\Xojo\Testing\FileTypeSets
OutputBaseFilename=SetupFileTypeSetExample
; If you have an End User License Agreement (EULA) that you want the user to agree to before letting the install continue,
; put the path to it here.
LicenseFile=
Compression=lzma
SolidCompression=yes
ChangesAssociations=yes

[Languages]
Name: "english"; MessagesFile: "compiler:Default.isl"

[Tasks]
Name: "desktopicon"; Description: "{cm:CreateDesktopIcon}"; GroupDescription: "{cm:AdditionalIcons}"; Flags: unchecked

; These directories will be created by the installer inside the DefaultDirName (defined above).
[Dirs]
Name: "{app}\FileTypeSetExample Libs"
Name: "{app}\FileTypeSetExample Resources"

; These are the files to include.  By default you want to include the EXE plus the Libs and Resources folders
; but you can include any other files you like as well.
; ** Be sure to change the path to point to your built application. **
[Files]
Source: ".\Builds - FileTypeSetExample.xojo_binary_project\Windows\FileTypeSetExample\FileTypeSetExample.exe"; DestDir: "{app}"; Flags: ignoreversion
Source: ".\Builds - FileTypeSetExample.xojo_binary_project\Windows\FileTypeSetExample\FileTypeSetExample Libs\*"; DestDir: "{app}\FileTypeSetExample Libs"; Flags: ignoreversion recursesubdirs createallsubdirs
Source: ".\Builds - FileTypeSetExample.xojo_binary_project\Windows\FileTypeSetExample\FileTypeSetExample Resources\*"; DestDir: "{app}\FileTypeSetExample Resources"; Flags: ignoreversion recursesubdirs createallsubdirs

; NOTE: Don't use "Flags: ignoreversion" on any shared system files

; Creates icons/links in the Start Menu and/or the desktop if the user chooses during installation.
[Icons]
Name: "{group}\FileTypeSetExample"; Filename: "{app}\FileTypeSetExample.exe"
Name: "{commondesktop}\FileTypeSetExample"; Filename: "{app}\FileTypeSetExample.exe"; Tasks: desktopicon

; Give the user the option to run the app after the installation is finished.
[Run]
Filename: "{app}\FileTypeSetExample.exe"; Description: "{cm:LaunchProgram,XojoApp}"; Flags: nowait postinstall skipifsilent

[Registry]
Root: HKCR; Subkey: ".xojotext"; ValueType: string; ValueName: ""; ValueData: "FileTypeSetExample"; Flags: uninsdeletevalue 
Root: HKCR; Subkey: "FileTypeSetExample"; ValueType: string; ValueName: ""; ValueData: "FileTypeSetExample"; Flags: uninsdeletekey
Root: HKCR; Subkey: "FileTypeSetExample\DefaultIcon"; ValueType: string; ValueName: ""; ValueData: "{app}\FiletypeSetExample Resources\txt.ico"
Root: HKCR; Subkey: "FileTypeSetExample\shell\open\command"; ValueType: string; ValueName: ""; ValueData: """{app}\FileTypeSetExample.exe"" ""%1"""
